#pragma once

#include <infra/yasm/zoom/components/serialization/history/history.h>
#include <infra/yasm/zoom/components/containers/series.h>
#include <infra/yasm/zoom/components/containers/accumulator_mapping.h>

#include <util/system/spinlock.h>

namespace NZoom::NAggregators {
    class IHistoryAggregatorVisitor {
    public:
        virtual ~IHistoryAggregatorVisitor() = default;

        virtual void OnRequest(const NZoom::NProtobuf::THistoryRequest& request) = 0;
        virtual void OnStatusCode(NZoom::NHost::THostName hostName, NYasm::NInterfaces::NInternal::THistoryAggregatedSeries::EStatusCode statusCode) = 0;
        virtual void OnContainer(const NZoom::NContainers::TTimestampedSeriesContainer& container) = 0;
        virtual void OnFinish() = 0;
    };

    class THistoryAggregator {
    public:
        THistoryAggregator(const NZoom::NYasmConf::TYasmConf& conf)
            : AccumulatorMapping(conf, NZoom::NAccumulators::EAggregationMethod::MetaGroup)
        {
        }

        void AddRequest(const NZoom::NProtobuf::THistoryRequest& request);
        void AddMetagroup(NZoom::NHost::THostName metagroup, const TVector<NZoom::NHost::THostName>& groups);

        void Mul(const NZoom::NProtobuf::THistoryResponse& response);
        void Overwrite(const THistoryAggregator& otherAggregator, const NZoom::NContainers::IOverwritePolicy& policy);
        void Overwrite(const THistoryAggregator& otherAggregator);
        void OverwriteSince(const THistoryAggregator& otherAggregator, TInstant since, TInstant until);
        void OverwriteContinuous(const THistoryAggregator& otherAggregator);
        void Visit(IHistoryAggregatorVisitor& visitor) const;

    private:
        struct TSeriesContainer {
            TSeriesContainer(const NZoom::NProtobuf::THistoryRequest& request,
                             NZoom::NContainers::TAccumulatorMapping& accumulatorMapping);

            void Mul(const NZoom::NProtobuf::THistoryResponse& response);
            void Visit(IHistoryAggregatorVisitor& visitor) const;

            NZoom::NContainers::TTimestampedSeriesContainer Container;
            THashMap<NZoom::NHost::THostName, THashSet<NYasm::NInterfaces::NInternal::THistoryAggregatedSeries::EStatusCode>> StatusCodes;
            TAdaptiveLock Lock;
        };

        class TOverwritingVisitor final : public IHistoryAggregatorVisitor {
        public:
            TOverwritingVisitor(THistoryAggregator* aggregator, const NZoom::NContainers::IOverwritePolicy& policy);

            void OnRequest(const NZoom::NProtobuf::THistoryRequest& request) override;
            void OnStatusCode(NZoom::NHost::THostName hostName, NYasm::NInterfaces::NInternal::THistoryAggregatedSeries::EStatusCode statusCode) override;
            void OnContainer(const NZoom::NContainers::TTimestampedSeriesContainer& container) override;
            void OnFinish() override;

        private:
            THistoryAggregator* Aggregator = nullptr;
            const NZoom::NContainers::IOverwritePolicy& Policy;
            const NZoom::NProtobuf::THistoryRequest* CurrentRequest = nullptr;
            TSeriesContainer* CurrentContainer = nullptr;
        };

        NZoom::NContainers::TAccumulatorMapping AccumulatorMapping;

        THashMap<NZoom::NHost::THostName, THashSet<NZoom::NHost::THostName>> GroupsToMetagroups;

        THashMap<NZoom::NProtobuf::THistoryRequest, TSeriesContainer> Containers;
    };
}
