#include "metagroup.h"

using namespace NZoom::NAggregators;

TMetagroupAggregator::TMetagroupAggregator(const NZoom::NYasmConf::TTypeConf &conf)
    : Conf(conf)
{
}

void TMetagroupAggregator::Mul(TTimestamp timestamp, const NZoom::NRecord::TRecord &record) {
    auto requiredSize = timestamp + 1;
    Containers.reserve(requiredSize);

    for (auto timestamp: xrange(Containers.size(), requiredSize)) {
        Y_UNUSED(timestamp);
        Containers.emplace_back(0, NZoom::NContainers::TMetaGroupContainer(Conf));
    }

    auto& matchedInstancesAndContainer = Containers[timestamp];
    matchedInstancesAndContainer.first++;
    matchedInstancesAndContainer.second.Mul(record);
}

TVector<TMetagroupAggregator::TResult> TMetagroupAggregator::GetValues() {
    TVector<TMetagroupAggregator::TResult> result;

    for (auto idx: xrange(Containers.size())) {
        auto& matchedInstancesAndContainer = Containers[idx];
        auto matchedInstances = matchedInstancesAndContainer.first;
        auto& container = matchedInstancesAndContainer.second;
        if (container.Len() > 0) {
            result.emplace_back(idx, matchedInstances, container.GetRecord());
        }
    }

    return result;
}
