#pragma once

#include <infra/yasm/zoom/components/containers/metagroup.h>
#include <infra/yasm/zoom/components/yasmconf/yasmconf.h>
#include <infra/yasm/zoom/components/record/record.h>
#include <util/generic/xrange.h>

namespace NZoom {
    namespace NAggregators {
        class TMetagroupAggregator {

        public:
            using TTimestamp = size_t;
            using TMatchedInstances = ui64;

            struct TResult {
                TTimestamp Timestamp;
                TMatchedInstances MatchedInstances;
                NZoom::NRecord::TRecord Record;

                TResult(TTimestamp timestamp, TMatchedInstances matchedInstances, NZoom::NRecord::TRecord record)
                    : Timestamp(timestamp)
                    , MatchedInstances(matchedInstances)
                    , Record(std::move(record))
                {
                }
            };

            TMetagroupAggregator(const NZoom::NYasmConf::TTypeConf& conf);

            void Mul(TTimestamp timestamp, const NZoom::NRecord::TRecord& record);
            TVector<TResult> GetValues();


        private:
            const NZoom::NYasmConf::TTypeConf& Conf;
            TVector<std::pair<TMatchedInstances, NZoom::NContainers::TMetaGroupContainer>> Containers;
        };
    }
}
