#pragma once

#include <infra/yasm/common/points/value/types.h>
#include <infra/yasm/common/labels/tags/instance_key.h>

#include <util/generic/hash.h>

namespace NZoom {
    namespace NAggregators {
        class TTaggedMetricManager {
        private:
            THashMap<TString, NZoom::NValue::TMetricManager> Managers;

        public:
            NZoom::NValue::TMetricManager& Create(NTags::TInstanceKey instanceKey) {
                THashMap<TString, NZoom::NValue::TMetricManager>::insert_ctx ctx;
                auto newIt = Managers.find(instanceKey.GetItype(), ctx);
                if (newIt != Managers.end()) {
                    return newIt->second;
                }
                auto it = Managers.emplace_direct(ctx, instanceKey.GetItype(), NZoom::NValue::TMetricManager());
                return it->second;
            }

            TVector<std::pair<TString, NZoom::NValue::TMetricManager>> Get() const {
                TVector<std::pair<TString, NZoom::NValue::TMetricManager>> result;
                result.reserve(Managers.size());
                for (const auto& pair : Managers) {
                    result.emplace_back(pair.first, pair.second);
                }
                return result;
            }
        };
    }
}
