#pragma once

#include "tag_tree.h"

#include <infra/yasm/common/labels/tags/instance_key.h>
#include <infra/yasm/common/labels/tags/request_key.h>
#include <infra/yasm/common/labels/signal/signal_name.h>

#include <util/generic/bitmap.h>

namespace NZoom::NAggregators {
    class TSubscriptionFilter {
    public:
        using TSeriesMask = TBitMap<2 << 22>;

        void Add(const NTags::TRequestKey& requestKey, const TVector<NZoom::NSignal::TSignalName>& signals) noexcept;

        TDynBitMap Match(NTags::TInstanceKey instanceKey, const TVector<NZoom::NSignal::TSignalName>& signals) const noexcept;

        void Clear();

    private:
        TTagTree TagTree;
        TSeriesMask SeriesMask;
    };
}
