#include "subscription_filter.h"

#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/xrange.h>

using namespace NTags;
using namespace NZoom::NAggregators;
using namespace NZoom::NSignal;

class TSubscriptionFilterTest: public TTestBase {
    UNIT_TEST_SUITE(TSubscriptionFilterTest);
    UNIT_TEST(TestEmpty)
    UNIT_TEST(TestAddAndMatch)
    UNIT_TEST(TestMultipleValues)
    UNIT_TEST(TestOnlyItype)
    UNIT_TEST(TestSameValue)
    UNIT_TEST_SUITE_END();

private:
    TVector<TSignalName> ToSignalList(TVector<TStringBuf> signals) {
        TVector<TSignalName> result;
        for (const auto signal : signals) {
            result.emplace_back(signal);
        }
        return result;
    }

    TDynBitMap ToBitMap(const TVector<size_t>& positions) {
        TDynBitMap result;
        for (const auto pos : positions) {
            result.Set(pos);
        }
        return result;
    }

    inline void TestAddAndMatch() {
        TSubscriptionFilter filter;

        filter.Add(TRequestKey::FromString("itype=addrsupper;geo=sas"), ToSignalList({"first_signal", "third_signal"}));

        UNIT_ASSERT_EQUAL(
            filter.Match(
                TInstanceKey::FromNamed("addrsupper|ctype=prestable;geo=sas;prj=addrs|tier"),
                ToSignalList({"first_signal", "second_signal"})
            ),
            ToBitMap({0})
        );
        UNIT_ASSERT_EQUAL(
            filter.Match(
                TInstanceKey::FromNamed("addrsupper|ctype=prestable;geo=man;prj=addrs|tier"),
                ToSignalList({"first_signal"})
            ),
            ToBitMap({})
        );
    }

    inline void TestEmpty() {
        TSubscriptionFilter filter;

        UNIT_ASSERT_EQUAL(
            filter.Match(
                TInstanceKey::FromNamed("addrsupper|ctype=prestable;geo=sas;prj=addrs|tier"),
                ToSignalList({"first_signal"})
            ),
            ToBitMap({})
        );
    }

    inline void TestMultipleValues() {
        TSubscriptionFilter filter;

        filter.Add(TRequestKey::FromString("itype=addrsupper;geo=sas"), ToSignalList({"first_signal"}));

        UNIT_ASSERT_EQUAL(
            filter.Match(
                TInstanceKey::FromNamed("addrsupper|ctype=prestable;geo=sas,man;prj=addrs|tier"),
                ToSignalList({"first_signal"})
            ),
            ToBitMap({0})
        );
    }

    inline void TestOnlyItype() {
        TSubscriptionFilter filter;

        filter.Add(TRequestKey::FromString("itype=addrsupper"), ToSignalList({"first_signal"}));

        UNIT_ASSERT_EQUAL(
            filter.Match(
                TInstanceKey::FromNamed("addrsupper|ctype=prestable;geo=sas;prj=addrs|tier"),
                ToSignalList({"first_signal"})
            ),
            ToBitMap({0})
        );
    }

    inline void TestSameValue() {
        TSubscriptionFilter filter;
        filter.Add(TRequestKey::FromString("itype=addrsupper;ctype=other"), ToSignalList({"first_signal"}));
        filter.Add(TRequestKey::FromString("itype=addrsupper;ctype=something"), ToSignalList({"first_signal"}));
        UNIT_ASSERT_EQUAL(
            filter.Match(
                TInstanceKey::FromNamed("addrsupper|ctype=other|tier"),
                ToSignalList({"first_signal"})
            ),
            ToBitMap({0})
        );
    }
};

UNIT_TEST_SUITE_REGISTRATION(TSubscriptionFilterTest);
