#include "chunk.h"

#include <library/cpp/testing/unittest/gtest.h>
#include <library/cpp/testing/unittest/registar.h>

namespace NYasmServer {

    Y_UNIT_TEST_SUITE(TestChunk) {
        Y_UNIT_TEST(TestEncodeDecode) {
            TVector<NZoom::NValue::TValue> valuesEncoded;
            valuesEncoded.emplace_back();
            valuesEncoded.emplace_back(1);
            valuesEncoded.emplace_back();
            valuesEncoded.emplace_back(3);
            valuesEncoded.emplace_back(4);
            valuesEncoded.emplace_back();
            valuesEncoded.emplace_back();
            valuesEncoded.emplace_back(7);
            valuesEncoded.emplace_back(8);
            valuesEncoded.emplace_back(9);

            TMaybe<ESeriesKind> seriesKind;
            TString data = EncodeChunk(valuesEncoded, seriesKind, true);
            TVector<NZoom::NValue::TValue> valuesDecoded = DecodeChunk(data, seriesKind.GetRef(), valuesEncoded.size());

            UNIT_ASSERT_VALUES_EQUAL(valuesEncoded, valuesDecoded);
        }

        Y_UNIT_TEST(TestAllNone) {
            TVector<NZoom::NValue::TValue> valuesEncoded(11);

            TMaybe<ESeriesKind> seriesKind;
            TString data = EncodeChunk(valuesEncoded, seriesKind, true);
            UNIT_ASSERT(!seriesKind.Defined());
            UNIT_ASSERT(data.empty());
            data = EncodeChunk(valuesEncoded, seriesKind, false);
            UNIT_ASSERT(!seriesKind.Defined());
            UNIT_ASSERT(!data.empty());
            TVector<NZoom::NValue::TValue> valuesDecoded = DecodeChunk(data, ESeriesKind::Double, valuesEncoded.size());
            UNIT_ASSERT_VALUES_EQUAL(valuesEncoded, valuesDecoded);
            valuesDecoded = DecodeChunk(data, ESeriesKind::CountedSum, valuesEncoded.size());
            UNIT_ASSERT_VALUES_EQUAL(valuesEncoded, valuesDecoded);
            valuesDecoded = DecodeChunk(data, ESeriesKind::Histogram, valuesEncoded.size());
            UNIT_ASSERT_VALUES_EQUAL(valuesEncoded, valuesDecoded);
        }

        Y_UNIT_TEST(TestMultipleTypes) {
            TVector<NZoom::NValue::TValue> valuesEncoded;
            valuesEncoded.emplace_back(NZoom::NHgram::THgram::Small(TVector<double>{2, 3, 4}, 2));
            valuesEncoded.emplace_back(2);
            valuesEncoded.emplace_back(3);
            valuesEncoded.emplace_back(4);
            valuesEncoded.emplace_back(NZoom::NHgram::THgram::Small(TVector<double>{5, 6, 7}, 5));
            valuesEncoded.emplace_back();
            valuesEncoded.emplace_back();

            TVector<NZoom::NValue::TValue> valuesExpected;
            valuesExpected.emplace_back(NZoom::NHgram::THgram::Small(TVector<double>{2, 3, 4}, 2));
            valuesExpected.emplace_back();
            valuesExpected.emplace_back();
            valuesExpected.emplace_back();
            valuesExpected.emplace_back(NZoom::NHgram::THgram::Small(TVector<double>{5, 6, 7}, 5));
            valuesExpected.emplace_back();
            valuesExpected.emplace_back();

            TMaybe<ESeriesKind> seriesKind;
            TString data = EncodeChunk(valuesEncoded, seriesKind, true);
            TVector<NZoom::NValue::TValue> valuesDecoded = DecodeChunk(data, seriesKind.GetRef(), valuesEncoded.size());

            UNIT_ASSERT_VALUES_EQUAL(valuesExpected, valuesDecoded);
        }
    }
} // namespace NYasmServer
