#pragma once

#include "bit_stream.h"
#include "zoom_types.h"

namespace NYasmServer {
    class TCountedSumEncoder {
    public:
        using TValueType = TCountedSum;

        void Write(TCountedSum value, TString& stream, ui32& bitPosition) {
            CountWriter.Write(value.GetCount(), stream, bitPosition);
            SumWriter.Write(value.GetSum(), stream, bitPosition);
        }
        void Clear() {
            CountWriter.Clear();
            SumWriter.Clear();
        }

    private:
        TDeltaIntEncoder CountWriter;
        TXorDoubleEncoder SumWriter;
    };

    class TCountedSumDecoder {
    public:
        using TValueType = TCountedSum;

        TCountedSum Read(const TString& stream, size_t& bitPosition) {
            auto count = CountReader.Read(stream, bitPosition);
            auto sum = SumReader.Read(stream, bitPosition);
            return TCountedSum(count, sum);
        }

        void Clear() {
            CountReader.Clear();
            SumReader.Clear();
        }

    private:
        TDeltaIntDecoder CountReader;
        TXorDoubleDecoder SumReader;
    };
} // namespace NYasmServer
