#pragma once

#include "zoom_types.h"

namespace NYasmServer {
    class THistogramEncoder {
    public:
        using TValueType = THistogram;

        void Clear() {
            LastValue.Reset();
        }

        void Write(THistogram value, TString& stream, ui32& bitPosition);

    private:
        void WriteVector(const TVector<ui64>& values, bool writeSize, TString& stream, ui32& bitPosition);
        void WriteVector(const TVector<double>& values, bool writeSize, TString& stream, ui32& bitPosition);

        void Write(const TSimpleHistogram& hist, TString& stream, ui32& bitPosition);
        void Write(const TUserHistogram& hist, TString& stream, ui32& bitPosition);
        void Write(const TLogHistogram& hist, TString& stream, ui32& bitPosition);

    private:
        THistogram LastValue;
    };

    class THistogramDecoder {
    public:
        using TValueType = THistogram;

        const THistogram& Read(const TString& stream, size_t& bitPosition);

        void Clear() {
            LastValue.Reset();
        }

    private:
        void ReadFullSimpleSingleValue(const TString& stream, size_t& bitPosition);
        void ReadFullSimpleZeroCount(const TString& stream, size_t& bitPosition);
        void ReadFullSimpleNormal(const TString& stream, size_t& bitPosition);
        void ReadFullLog(const TString& stream, size_t& bitPosition);
        void ReadFullUser(const TString& stream, size_t& bitPosition);

        void ReadPartialSimpleSingleValue(const TString& stream, size_t& bitPosition);
        void ReadPartialSimpleZeroCount(const TString& stream, size_t& bitPosition);
        void ReadPartialSimpleNormal(const TString& stream, size_t& bitPosition);
        void ReadPartialLog(const TString& stream, size_t& bitPosition);
        void ReadPartialUser(const TString& stream, size_t& bitPosition);

    private:
        THistogram LastValue;
    };
} // namespace NYasmServer
