#pragma once

#include <infra/yasm/common/points/value/types.h>

#include <util/datetime/base.h>
#include <util/generic/ptr.h>
#include <util/generic/maybe.h>

namespace NYasmServer {
    enum class ESeriesKind {
        Double,
        CountedSum,
        Histogram
    };

    class TValueTyper : public NZoom::NValue::IUpdatable {
    public:
        void MulNone() final {
        }

        void MulFloat(const double) final {
            Type = ESeriesKind::Double;
        }

        void MulVec(const TVector<double>&) final {
            Type = ESeriesKind::Histogram;
        }

        void MulCountedSum(const double, const ui64) final {
            Type = ESeriesKind::CountedSum;
        }

        void MulHgram(const NZoom::NHgram::THgram&) final {
            Type = ESeriesKind::Histogram;
        }

        void MulHyperLogLog(const ::THyperLogLog&) final {
            Y_FAIL("This is impossible - hyperloglogs are not passed between server processes");
        }

        TMaybe<ESeriesKind> GetType() const {
            return Type;
        }

    private:
        TMaybe<ESeriesKind> Type;
    };

    struct TSeriesChunk {
        TInstant StartTime;
        TString Data;
        ui32 ValuesCount;
    };

    class ISeriesVisitor {
    public:
        virtual ~ISeriesVisitor() = default;

        virtual void OnHeader(TInstant start, size_t count) = 0;
        virtual void OnValue(NZoom::NValue::TValueRef value) = 0;
    };

    enum class ESnapshotMode {
        AsIs,
        PadNulls
    };

    class IRecordList {
    public:
        virtual ESeriesKind GetKind() const = 0;
        virtual TInstant GetStartTime() const = 0;
        virtual TInstant GetEndTime() const = 0;
        virtual TMaybe<TSeriesChunk> GetChunkStartingAt(TInstant timestamp, ESnapshotMode mode) const = 0;
        virtual void AppendChunk(TInstant start, TString data, size_t valuesCount) = 0;
        virtual ~IRecordList() = default;

        virtual void IterValues(TInstant from, TInstant to, ISeriesVisitor& visitor) const = 0;
    };

    using TSeriesPtr = TAtomicSharedPtr<IRecordList>;
} // namespace NYasmServer
