#include "zoom_converters.h"

#include <library/cpp/testing/unittest/gtest.h>
#include <library/cpp/testing/unittest/registar.h>

namespace NYasmServer {

    using NZoom::NHgram::THgram;
    using NZoom::NValue::TValue;

    Y_UNIT_TEST_SUITE(TestZoomConverters) {
        Y_UNIT_TEST(TestDouble) {
            auto result = ToZoom(15.6);
            UNIT_ASSERT_EQUAL(result, TValue(15.6));
        }

        Y_UNIT_TEST(TestCountedSum) {
            auto result = ToZoom(TCountedSum(26, 15.6));
            UNIT_ASSERT_EQUAL(result, TValue(15.6, 26));
        }

        Y_UNIT_TEST(TestLogHistogram) {
            TLogHistogram hist;
            hist.SetZeroCount(15);
            hist.SetStartPower(-5);
            hist.MutableWeights() = {14, 5, 6};

            auto result = ToZoom(THistogram(hist));
            UNIT_ASSERT_EQUAL(result, TValue(THgram::Normal({14.0, 5.0, 6.0}, 15, -5)));
        }

        Y_UNIT_TEST(TestSimpleHistogram) {
            TSimpleHistogram hist;
            hist.SetZeroCount(15);
            hist.MutableValues() = {16.4, 12.2, 5.3};

            auto result = ToZoom(THistogram(hist));
            UNIT_ASSERT_EQUAL(result, TValue(THgram::Small({16.4, 12.2, 5.3}, 15)));
        }

        Y_UNIT_TEST(TestUserHistogram) {
            TUserHistogram hist;
            hist.AppendBucket(1, 10);
            hist.AppendBucket(2, 0);
            hist.AppendBucket(4, 20);
            hist.AppendBucket(5, 30);
            hist.AppendBucket(6, 0);

            auto result = ToZoom(THistogram(hist));
            UNIT_ASSERT_EQUAL(result, TValue(THgram::Ugram({{1, 2, 10},
                                                            {4, 5, 20},
                                                            {5, 6, 30}})));
        }

        Y_UNIT_TEST(TestEmptyUserHistogram) {
            TUserHistogram hist;

            auto result = ToZoom(THistogram(hist));
            UNIT_ASSERT_EQUAL(result, TValue(THgram::EmptyUgram()));
        }
    }
} // namespace NYasmServer
