#include "accumulator_mapping.h"

using namespace NZoom::NContainers;
using namespace NZoom::NAccumulators;
using namespace NZoom::NSignal;

TMaybe<EAccumulatorType> TAccumulatorMapping::GetAccumulatorType(const TString& itype, TSignalName signalName) {
    auto newIt = Accumulators.find(itype);
    if (newIt != Accumulators.end()) {
        return GetAccumulatorType(newIt->second.GetAccumulator(signalName));
    }

    const auto& conf = Conf.GetTypeConf(itype, true);
    auto [it, _] = Accumulators.emplace(
            itype,
            TStorage<TDescriptor>(conf.GetSignals(), conf.GetPatterns(), AggregationMethod));

    return GetAccumulatorType(it->second.GetAccumulator(signalName));
}

TMaybe<EAccumulatorType> TAccumulatorMapping::GetAccumulatorType(TDescriptor* descriptor) {
    if (descriptor != nullptr) {
        return {descriptor->Type};
    } else {
        return Nothing();
    }
}
