#pragma once

#include "storage.h"

#include <infra/yasm/zoom/components/yasmconf/yasmconf.h>

namespace NZoom::NContainers {
    class TAccumulatorMapping {
    public:
        struct TDescriptor {
            TDescriptor(NZoom::NAccumulators::EAccumulatorType type)
                : Type(type)
            {
            }

            const NZoom::NAccumulators::EAccumulatorType Type;
        };

        TAccumulatorMapping(const NZoom::NYasmConf::TYasmConf& conf,
                            NZoom::NAccumulators::EAggregationMethod aggregationMethod)
            : Conf(conf)
            , AggregationMethod(aggregationMethod)
        {
        }

        TMaybe<NZoom::NAccumulators::EAccumulatorType> GetAccumulatorType(const TString& itype, NZoom::NSignal::TSignalName signalName);

    private:
        TMaybe<NZoom::NAccumulators::EAccumulatorType> GetAccumulatorType(TDescriptor* descriptor);

        using TAccumulatorMap = absl::flat_hash_map<TString, TStorage<TDescriptor>, THash<TString>>;

        const NZoom::NYasmConf::TYasmConf& Conf;
        NZoom::NAccumulators::EAggregationMethod AggregationMethod;
        TAccumulatorMap Accumulators;
    };

}
