#pragma once

#include "storage.h"

#include <infra/yasm/zoom/components/record/record.h>

#include <library/cpp/threading/light_rw_lock/lightrwlock.h>

#include <util/datetime/base.h>

namespace NZoom {
    namespace NContainers {

        class TAgentWrappedAccumulator {
        private:
            NZoom::NAccumulators::TAccumulator Accumulator;
            TInstant ExpireTime;
            TInstant TTL;

        public:
            TAgentWrappedAccumulator(NZoom::NAccumulators::EAccumulatorType type);

            void Mul(const NZoom::NValue::TValueRef& value, const TInstant expireTime, const TInstant ttl);
            bool IsExpired(const TInstant now) const noexcept;
            bool IsExpiredTTL(const TInstant now) const noexcept;
            void Clean();
            NZoom::NValue::TValueRef GetValue() const;
        };

        class TAgentContainer {
        private:
            TLightRWLock Mutex;
            TStorage<TAgentWrappedAccumulator> Storage;

        public:
            TAgentContainer(const NZoom::NYasmConf::TTypeConf& conf, const bool hostAggregation=false);

            void Mul(const TAgentContainer& other);
            void Mul(const NZoom::NRecord::TRecord& record);

            void MulTTL(const TAgentContainer& other, const TDuration ttl);
            void MulTTL(const NZoom::NRecord::TRecord& record, const TDuration ttl);

            size_t Len() const noexcept;
            void Clean();
            void Clean(const TInstant explicitNow); // Debugging hook
            void Process(NZoom::NRecord::ISignalValueCallback& callback) const;

            size_t Trim(const size_t targetSize);

        private:
            void MulInternal(const NZoom::NSignal::TSignalName& name, const NZoom::NValue::TValueRef& value,
                const TInstant expireTime, const TInstant ttl);
        };
    }
}
