from libcpp cimport bool as bool_t

from util.datetime.base cimport TDuration

from infra.yasm.zoom.components.record.record cimport TRecord, ISignalValueCallback
from infra.yasm.zoom.components.yasmconf.yasmconf cimport TTypeConf

cdef extern from "infra/yasm/zoom/components/containers/agent.h" namespace "NZoom::NContainers" nogil:
    cdef cppclass TAgentContainer:
        TAgentContainer(const TTypeConf& conf, bool_t host_aggregation) except +
        size_t Len()
        void Clean()
        void Mul(const TAgentContainer& other) except +
        void Mul(const TRecord& record) except +
        void MulTTL(const TRecord& other, const TDuration ttl) except +
        void Process(ISignalValueCallback&) except +
        size_t Trim(const size_t targetSize)
