#pragma once

#include "storage.h"

#include <infra/yasm/zoom/components/record/record.h>

#include <util/datetime/base.h>

namespace NZoom {
    namespace NContainers {

        class TWrappedAccumulator {
        private:
            NZoom::NAccumulators::TAccumulator Accumulator;
            TInstant ExpireTime;

        public:
            TWrappedAccumulator(NZoom::NAccumulators::EAccumulatorType type);

            void Mul(const NZoom::NValue::TValueRef& value, const TInstant expireTime);
            bool IsExpired(const TInstant now) const noexcept;
            void Clean();
            NZoom::NValue::TValueRef GetValue() const;
        };

        class TGroupContainer {
        private:
            TStorage<TWrappedAccumulator> Storage;

        public:
            TGroupContainer(const NZoom::NYasmConf::TTypeConf& conf);

            void Mul(const TGroupContainer& other, NZoom::NValue::TMetricManager& metricManager);
            void Mul(const NZoom::NRecord::TRecord& record, NZoom::NValue::TMetricManager& metricManager);

            size_t Len() const noexcept;
            void Clean();
            void Clean(const TInstant explicitNow); // Debugging hook
            void Process(NZoom::NRecord::ISignalValueCallback& callback) const;


        private:
            void MulInternal(const NZoom::NSignal::TSignalName& name, const NZoom::NValue::TValueRef& value,
                const TInstant expireTime, NZoom::NValue::TMetricManager& metricManager);
        };
    }
}
