#pragma once

#include "abstract.h"

#include <infra/yasm/common/points/accumulators/accumulators.h>
#include <infra/yasm/zoom/components/record/record.h>
#include <infra/yasm/common/labels/signal/signal_name.h>
#include <infra/yasm/common/points/value/types.h>
#include <infra/yasm/zoom/components/yasmconf/yasmconf.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_map.h>

#include <util/generic/hash.h>
#include <util/generic/vector.h>

namespace NZoom {
    namespace NContainers {

        class TIncompatibleSizeException: public std::invalid_argument {
        public:
            TIncompatibleSizeException(const TSourceLocation& sl, const size_t first, const size_t second);
        };

        class TTagMerger {
        private:
            absl::flat_hash_map<NSignal::TSignalName, NAccumulators::TAccumulatorsArray, THash<NSignal::TSignalName>> Accumulators;
            size_t LeftBorder = 0;
            size_t RightBorder = 0;

        public:
            TTagMerger(const NZoom::NYasmConf::TTypeConf& conf,
                       const TVector<NZoom::NSignal::TSignalName>& signals, const size_t size);

            TTagMerger(const NZoom::NYasmConf::TTypeConf& conf, INameIterator& signals, const size_t size);

            void MulContinuousRecord(const NZoom::NRecord::TContinuousRecord& record, const ssize_t offset);
            void MulSignalValues(const NZoom::NSignal::TSignalName& signal, const TVector<NZoom::NValue::TValue>& values,
                                 const ssize_t offset);
            void Process(NZoom::NRecord::IContinuousSignalCallback& callback) const;

            size_t GetLeftBorder() const noexcept;
            size_t GetRightBorder() const noexcept;

        private:
            void EmplaceSignal(const NZoom::NYasmConf::TTypeConf& conf, NZoom::NSignal::TSignalName&& signal, const size_t size);
        };
    }
}
