#include "metagroup.h"

using namespace NZoom::NContainers;
using namespace NZoom::NAccumulators;
using namespace NZoom::NSignal;
using namespace NZoom::NValue;
using namespace NZoom::NYasmConf;


TMetaGroupContainer::TMetaGroupContainer(const TTypeConf& conf)
        : Storage(conf.GetSignals(),
                  conf.GetPatterns(), EAggregationMethod::MetaGroup)
{
}

size_t TMetaGroupContainer::Len() const noexcept {
    return Storage.Len();
}


void TMetaGroupContainer::Mul(const TVector<std::pair<TSignalName, TValueRef>>& values) {
    for (const auto& p: values) {
        TAccumulator* acc = Storage.GetAccumulator(p.first);
        if (acc == nullptr) {
            continue;
        }
        acc->Mul(p.second);
    }
}

NZoom::NRecord::TRecord TMetaGroupContainer::GetRecord() {
    TVector<std::pair<TSignalName, TValue>> recordValues;
    recordValues.reserve(Storage.Len());
    for (const auto& p: Storage) {
        recordValues.emplace_back(p.first, p.second.GetValue());
    }
    return NZoom::NRecord::TRecord(std::move(recordValues));
}

void TMetaGroupContainer::Mul(const NZoom::NRecord::TRecord& record) {
    const auto& values = record.GetValues();
    for (const auto& p: values) {
        TAccumulator* acc = Storage.GetAccumulator(p.first);
        if (acc != nullptr) {
            acc->Mul(p.second);
        }
    }

}
