#pragma once

#include "storage.h"

#include <infra/yasm/zoom/components/record/record.h>
#include <infra/yasm/common/points/value/types.h>

#include <util/generic/vector.h>

namespace NZoom {
    namespace NContainers {
        class TMetaGroupContainer {
        private:
            TStorage<NZoom::NAccumulators::TAccumulator> Storage;

        public:
            TMetaGroupContainer(const NZoom::NYasmConf::TTypeConf& conf);

            size_t Len() const noexcept;

            void Mul(const TVector<std::pair<NZoom::NSignal::TSignalName, NZoom::NValue::TValueRef>>& values);
            void Mul(const NZoom::NRecord::TRecord& record);
            NZoom::NRecord::TRecord GetRecord();
        };
    }
}
