#include "rollup.h"

using namespace NZoom::NContainers;
using namespace NZoom::NAccumulators;
using namespace NZoom::NSignal;
using namespace NZoom::NValue;
using namespace NZoom::NYasmConf;


TRollupContainer::TRollupContainer(const TTypeConf& conf)
    : Storage(conf.GetPeriodicSignals(),
        conf.GetPeriodicPatterns(), EAggregationMethod::Rollup)
{
}

size_t TRollupContainer::Len() const noexcept {
    return Storage.Len();
}


void TRollupContainer::Mul(const TVector<std::pair<TSignalName, TValueRef>>& values) {
    for (const auto& p: values) {
        TAccumulator* acc = Storage.GetAccumulator(p.first);
        if (acc == nullptr) {
            continue;
        }
        acc->Mul(p.second);
    }
}

void TRollupContainer::Process(NZoom::NRecord::ISignalValueCallback& callback) const {
    callback.SetObjectsCount(Storage.Len());
    for (const auto& p: Storage) {
        auto value = p.second.GetValue();
        callback.OnSignalValue(p.first, value);
    }
}

void TRollupContainer::Mul(const NZoom::NRecord::TRecord& record) {
    const auto& values = record.GetValues();
    for (const auto& p: values) {
        TAccumulator* acc = Storage.GetAccumulator(p.first);
        if (acc != nullptr) {
            acc->Mul(p.second);
        }
    }

}
