#pragma once

#include <infra/yasm/zoom/components/record/record.h>
#include <infra/yasm/zoom/components/yasmconf/yasmconf.h>

namespace NZoom::NContainers {
    class ITimestampedSeriesContainerVisitor {
    public:
        virtual ~ITimestampedSeriesContainerVisitor() = default;

        virtual void OnStartTime(TInstant startTime) = 0;
        virtual void OnValueCount(size_t count) = 0;
        virtual void OnValue(NZoom::NValue::TValueRef value) = 0;
    };

    class IOverwritePolicy {
    public:
        virtual ~IOverwritePolicy() = default;

        virtual bool SkipOperation(TInstant leftStartTime, TInstant leftEndTime,
                                   TInstant rightStartTime, TInstant rightEndTime,
                                   TDuration resolution) const = 0;
        virtual bool SkipPoint(TInstant pointTime) const = 0;
    };

    class TOverwriteAnythingPolicy final : public IOverwritePolicy {
    public:
        bool SkipOperation(TInstant leftStartTime, TInstant leftEndTime,
                           TInstant rightStartTime, TInstant rightEndTime,
                           TDuration resolution) const override;
        bool SkipPoint(TInstant pointTime) const override;
    };

    class TOverwriteContinuousPolicy final : public IOverwritePolicy {
    public:
        bool SkipOperation(TInstant leftStartTime, TInstant leftEndTime,
                           TInstant rightStartTime, TInstant rightEndTime,
                           TDuration resolution) const override;
        bool SkipPoint(TInstant pointTime) const override;
    };

    class TOverwriteWithSkipPolicy final : public IOverwritePolicy {
    public:
        TOverwriteWithSkipPolicy(TInstant since, TInstant until);

        bool SkipOperation(TInstant leftStartTime, TInstant leftEndTime,
                           TInstant rightStartTime, TInstant rightEndTime,
                           TDuration resolution) const override;
        bool SkipPoint(TInstant pointTime) const override;

    private:
        TInstant Since;
        TInstant Until;
    };

    class TTimestampedSeriesContainer {
    public:
        TTimestampedSeriesContainer(TMaybe<NZoom::NAccumulators::EAccumulatorType> accumulator,
                                    TInstant startTime, TInstant endTime, TDuration resolution, bool merge);

        void Mul(const NZoom::NRecord::TTimestampedNamedSeries& series);
        void Overwrite(const TTimestampedSeriesContainer& other);
        void Overwrite(const TTimestampedSeriesContainer& other, const IOverwritePolicy& policy);
        void Visit(ITimestampedSeriesContainerVisitor& visitor) const;

    private:
        class TOverwritingVisitor final : public ITimestampedSeriesContainerVisitor {
        public:
            TOverwritingVisitor(TTimestampedSeriesContainer* container, const IOverwritePolicy& policy);

            void OnStartTime(TInstant startTime) override;
            void OnValueCount(size_t count) override;
            void OnValue(NZoom::NValue::TValueRef value) override;

        private:
            TTimestampedSeriesContainer* Container;
            const IOverwritePolicy& Policy;
            TInstant CurrentTime;
        };

        TInstant StartTime;
        TDuration Resolution;

        TInstant ActualStartTime;
        TInstant ActualEndTime;

        TMaybe<NZoom::NAccumulators::TCompactAccumulatorsArray> Accumulators;
        bool Merge;
    };
}
