from util.datetime.base cimport TInstant
from util.generic.string cimport TString

from infra.yasm.zoom.components.value_types cimport TValue

cdef extern from "infra/yasm/zoom/components/record/record.h" namespace "NZoom::NRecord" nogil:
    cdef cppclass TRecord:
        void Process(ISignalValueCallback&) except +
        size_t Len()

    cdef cppclass TWindowRecord:
        TWindowRecord(const size_t size) except +
        void Process(IContinuousValueCallback&) except +
        void Push(TInstant timestamp, const TValue&) except +
        size_t Len()

    cdef cppclass TTaggedRecord:
        void Process(ITagRecordCallback&) except +

    cdef cppclass TSingleMultiTaggedRecord:
        const TRecord& GetRecord();

    cdef cppclass TContinuousRecord:
        void Process(IContinuousSignalCallback& callback) except +

    cdef cppclass ISignalValueCallback:
        pass

    cdef cppclass ITagRecordCallback:
        pass

    cdef cppclass IContinuousSignalCallback:
        pass

    cdef cppclass IContinuousValueCallback:
        pass

    cdef cppclass TContinuousSignalToRecordCallback(IContinuousSignalCallback):
        TContinuousRecord* BuildRecord() except +

    cdef cppclass TSignalValueToRecordStorageCallback(ISignalValueCallback):
        TSignalValueToRecordStorage() except +
        TRecord* Create() except +

    ctypedef TTaggedRecord* TTaggedRecordPtr

