#include "record.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NZoom::NRecord;
using namespace NZoom::NValue;
using namespace NZoom::NHgram;

Y_UNIT_TEST_SUITE(TZoomTRecordTest) {

    TNamedSeries BuildSimpleSeries(const TString& name, const std::initializer_list<double>& values) {
        TVector<TValue> items;
        items.reserve(std::distance(values.begin(), values.end()));
        for (const double value: values) {
            items.emplace_back(value);
        }
        return TNamedSeries(name, std::move(items));
    }

    Y_UNIT_TEST(ContinuousRecordCopyingViaCallback) {
        TVector<TNamedSeries> values;
        values.emplace_back(BuildSimpleSeries("name1", {1, 2, 3, 4}));
        values.emplace_back(BuildSimpleSeries("name2", {3, 4, 5}));
        values.emplace_back(BuildSimpleSeries("name3", {7, 8, 9}));

        const TContinuousRecord contRecord(std::move(values));

        TContinuousSignalToRecordCallback callback;
        contRecord.Process(callback);
        THolder<TContinuousRecord> copy(callback.BuildRecord());
        UNIT_ASSERT_EQUAL(contRecord, *copy);
    }


    Y_UNIT_TEST(RecordCopyingViaCallback) {
        TVector<std::pair<NZoom::NSignal::TSignalName, NZoom::NValue::TValue>> values;
        values.emplace_back(TString("name0"), NZoom::NValue::TValue());
        values.emplace_back(TString("name1"), NZoom::NValue::TValue(1.0));
        values.emplace_back(TString("name2"), NZoom::NValue::TValue(2, 2));
        values.emplace_back(TString("name3"), NZoom::NValue::TValue({1, 2, 3}));
        values.emplace_back(TString("name4"), NZoom::NValue::TValue(THgram::Small({1, 2, 3}, 10)));
        values.emplace_back(TString("name5"), NZoom::NValue::TValue(
            THgram::Normal({0.0, 51.0, 1.0, 1.0, 50.0}, 0, -1)));
        values.emplace_back(TString("name6"), NZoom::NValue::TValue(
            THgram::Ugram({
                TUgramBucket(1.0, 2.0, 2.0),
                TUgramBucket(2.0, 2.0, 1.0),
                TUgramBucket(2.0, 3.0, 2.0)
             })));

        TRecord orig(std::move(values));
        TSignalValueToRecordStorageCallback callback;
        orig.Process(callback);
        THolder<TRecord> copy(callback.Create());
        UNIT_ASSERT_EQUAL(orig, *copy);
    }

}
