#pragma once

#include <cmath>

namespace NZoom {
    namespace NPython {
        // 2 ^ 53, because double has 53 mantissa bits
        constexpr double MAX_WHOLE_F64 = 9007199254740992.0;
        constexpr double MIN_WHOLE_F64 = -MAX_WHOLE_F64;

        inline bool IsInteger(double v) noexcept {
            double intpart;
            if (v > MIN_WHOLE_F64 && v < MAX_WHOLE_F64 && std::modf(v, &intpart) == 0.0) {
                return true;
            } else {
                return false;
            }
        }
    }
}
