#include "msgpack_utils.h"

#include <util/generic/yexception.h>

using namespace NZoom::NPython;


TStringBuf NZoom::NPython::AsStrBuf(const msgpack::object& obj) {
    if (obj.type == msgpack::type::STR) {
        return TStringBuf(obj.via.str.ptr, obj.via.str.size);
    } else if (obj.type == msgpack::type::BIN) {
        return TStringBuf(obj.via.bin.ptr, obj.via.bin.size);
    }
    ythrow yexception() << "Object is not STR, nor BIN";
}

i64 NZoom::NPython::AsInt(const msgpack::object& obj) {
    if (obj.type == msgpack::type::POSITIVE_INTEGER) {
        return obj.via.u64;
    } else if (obj.type == msgpack::type::NEGATIVE_INTEGER) {
        return obj.via.i64;
    }
    ythrow yexception() << "Object is not POSITIVE_INTEGER, nor NEGATIVE_INTEGER";
}
