#pragma once

#include <infra/yasm/common/points/value/types.h>

#include <util/generic/yexception.h>

namespace NZoom {
    namespace NPython {

        enum class EType {
            None,
            String,
            Int,
            Float,
            Vec,
            Unknown
        };

        class TAbstractValue {
        private:
            EType Type;

        public:
            inline TAbstractValue(EType type)
                : Type(type)
            {
            }

            virtual ~TAbstractValue() = default;

            inline void AssertType(EType target) const {
                if (Type != target) {
                    ythrow yexception() << "Wrong type";
                }
            }

            inline EType GetType() const noexcept {
                return Type;
            }
        };

        template<typename TValueType, typename TVecType>
        class TValueDeserializer {
            static std::pair<double, double> VecToPair(const TVecType& ugramBucket);
            static NZoom::NValue::TValue DeserializeHgram(const TVecType& values, const TValueType& zeros,
                const TValueType& startPower);
            static double ItemToFloat(const TValueType& v);
            static i64 ItemToInt(const TValueType& v);
            static NZoom::NValue::TValue GetValueFromVec(const TVecType& item, bool skipEmptyUgramBuckets);
            static NZoom::NValue::TValue DeserializeUgram(const TVecType& ugramBuckets, bool skipEmptyBuckets);

        public:
            static NZoom::NValue::TValue GetValue(const TValueType& value, bool skipEmptyUgramBuckets);
        };

    }
}

#include "abstract_value-inl.h"

