#include "json.h"

using namespace NZoom::NPython;

namespace {

    EType GetJsonType(const NJson::TJsonValue& object) {
        switch (object.GetType()) {
        case NJson::JSON_NULL:
            return EType::None;
        case NJson::JSON_STRING:
            return EType::String;
        case NJson::JSON_INTEGER:
        case NJson::JSON_UINTEGER:
            return EType::Int;
        case NJson::JSON_DOUBLE:
            return EType::Float;
        case NJson::JSON_ARRAY:
            return EType::Vec;
        default:
            return EType::Unknown;
        }
    }

}


TJsonValueHierarchy::TJsonPyValue::TJsonPyValue(const NJson::TJsonValue& object)
    : TAbstractValue(GetJsonType(object))
    , Object(object)
{
}

TStringBuf TJsonValueHierarchy::TJsonPyValue::AsString() const {
    AssertType(EType::String);
    return Object.GetString();
}

i64 TJsonValueHierarchy::TJsonPyValue::AsInt() const {
    AssertType(EType::Int);
    return Object.GetInteger();
}

double TJsonValueHierarchy::TJsonPyValue::AsFloat() const {
    AssertType(EType::Float);
    return Object.GetDouble();
}

TJsonValueHierarchy::TJsonVec TJsonValueHierarchy::TJsonPyValue::AsVec() const {
    AssertType(EType::Vec);
    return TJsonVec(Object);
}

TJsonValueHierarchy::TJsonVec::TJsonVec(const NJson::TJsonValue& object)
    : Object(object)
{
}

size_t TJsonValueHierarchy::TJsonVec::GetSize() const {
    return Object.GetArray().size();
}

TJsonValueHierarchy::TJsonPyValue TJsonValueHierarchy::TJsonVec::GetItem(const size_t idx) const {
    return TJsonPyValue(Object.GetArray()[idx]);
}

NZoom::NValue::TValue TJsonValueHierarchy::DeserializeValue(const NJson::TJsonValue& rootObject, bool skipEmptyUgramBuckets) {
    TJsonPyValue value(rootObject);
    return TValueDeserializer<TJsonPyValue, TJsonVec>::GetValue(value, skipEmptyUgramBuckets);
}
