#pragma once

#include <infra/yasm/zoom/components/serialization/deserializers/abstract/abstract_value.h>

#include <library/cpp/json/json_value.h>

namespace NZoom {
    namespace NPython {

        class TJsonValueHierarchy {
        private:

            class TJsonVec;

            class TJsonPyValue: public TAbstractValue {
            private:
                const NJson::TJsonValue& Object;

            public:
                TJsonPyValue(const NJson::TJsonValue& object);

                TStringBuf AsString() const;
                i64 AsInt() const;
                double AsFloat() const;
                TJsonVec AsVec() const;
            };

            class TJsonVec {
            private:
                const NJson::TJsonValue& Object;

            public:
                TJsonVec(const NJson::TJsonValue& object);

                size_t GetSize() const;
                TJsonPyValue GetItem(const size_t idx) const;
            };

        public:
            static NZoom::NValue::TValue DeserializeValue(const NJson::TJsonValue& rootObject, bool skipEmptyUgramBuckets);
        };

    }
}
