#include "callbacks.h"

#include <library/cpp/json/fast_sax/parser.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NZoom::NPython;

Y_UNIT_TEST_SUITE(TZoomJsonCallbacksParserTest) {

    Y_UNIT_TEST(SkipAll) {
        const TString json = "[\"a\", [\"b\", \"c\"], {\"d\":\"e\"}, 1, 1.0, null, \"f\"]";
        TZoomJsonDeserializingCallback cb(nullptr);
        TSkippingJsonCallback skipping(cb);
        cb.SetConsumer(&skipping);
        UNIT_ASSERT(NJson::ReadJsonFast(json, &cb));
    }

}
