#include "msgpack.h"

#include <infra/yasm/zoom/components/serialization/common/msgpack_utils.h>

using namespace NZoom::NPython;

namespace {

    EType GetMsgPackType(const msgpack::object& object) {
        switch (object.type) {
        case msgpack::type::NIL:
            return EType::None;
        case msgpack::type::STR:
        case msgpack::type::BIN:
            return EType::String;
        case msgpack::type::POSITIVE_INTEGER:
        case msgpack::type::NEGATIVE_INTEGER:
            return EType::Int;
        case msgpack::type::FLOAT:
            return EType::Float;
        case msgpack::type::ARRAY:
            return EType::Vec;
        default:
            return EType::Unknown;
        }
    }

}

TMsgPackValueHierarchy::TMsgPackPyValue::TMsgPackPyValue(const msgpack::object& object)
    : TAbstractValue(GetMsgPackType(object))
    , Object(object)
{
}

TStringBuf TMsgPackValueHierarchy::TMsgPackPyValue::AsString() const {
    AssertType(EType::String);
    return AsStrBuf(Object);
}

i64 TMsgPackValueHierarchy::TMsgPackPyValue::AsInt() const {
    AssertType(EType::Int);
    if (Object.type == msgpack::type::POSITIVE_INTEGER) {
        return Object.via.u64;
    } else {
        return Object.via.i64;
    }
}

double TMsgPackValueHierarchy::TMsgPackPyValue::AsFloat() const {
    AssertType(EType::Float);
    return Object.via.f64;
}

TMsgPackValueHierarchy::TMsgPackVec TMsgPackValueHierarchy::TMsgPackPyValue::AsVec() const {
    AssertType(EType::Vec);
    return TMsgPackVec(Object);
}

TMsgPackValueHierarchy::TMsgPackVec::TMsgPackVec(const msgpack::object& object)
    : Object(object)
{
}

size_t TMsgPackValueHierarchy::TMsgPackVec::GetSize() const {
    return Object.via.array.size;
}

TMsgPackValueHierarchy::TMsgPackPyValue TMsgPackValueHierarchy::TMsgPackVec::GetItem(const size_t idx) const {
    return TMsgPackPyValue(Object.via.array.ptr[idx]);
}


NZoom::NValue::TValue TMsgPackValueHierarchy::DeserializeValue(const msgpack::object& rootObject, bool skipEmptyUgramBuckets) {
    TMsgPackPyValue value(rootObject);
    return TValueDeserializer<TMsgPackPyValue, TMsgPackVec>::GetValue(value, skipEmptyUgramBuckets);
}
