#pragma once

#include <infra/yasm/zoom/components/serialization/deserializers/abstract/abstract_value.h>

#include <library/cpp/msgpack/strbuf_adaptor.h>
#include <library/cpp/msgpack/string_adaptor.h>
#include <contrib/libs/msgpack/include/msgpack.hpp>

namespace NZoom {
    namespace NPython {

        class TMsgPackValueHierarchy {
        private:

            class TMsgPackVec;

            class TMsgPackPyValue: public TAbstractValue {
            private:
                const msgpack::object& Object;

            public:
                TMsgPackPyValue(const msgpack::object& object);

                TStringBuf AsString() const;
                i64 AsInt() const;
                double AsFloat() const;

                TMsgPackVec AsVec() const;
            };

            class TMsgPackVec {
            private:
                const msgpack::object& Object;

            public:
                TMsgPackVec(const msgpack::object& object);

                size_t GetSize() const;
                TMsgPackPyValue GetItem(const size_t idx) const;
            };

        public:
            static NZoom::NValue::TValue DeserializeValue(const msgpack::object& rootObject, bool skipEmptyUgramBuckets);
        };
    }
}
