#pragma once

#include <infra/yasm/zoom/components/record/record.h>

#include <library/cpp/json/json_value.h>

#include <Python.h>

namespace NZoom {
    namespace NPython {

        NZoom::NValue::TValue* PyToValue(PyObject* value, bool skipEmptyUgramBuckets);
        NZoom::NValue::TValue PyToOwnedValue(PyObject* value, bool skipEmptyUgramBuckets);

        class TPyDeserializer {
        public:
            static NZoom::NRecord::TRecord* DeserializeDict(PyObject* value, bool skipEmptyUgramBuckets);
            static NZoom::NRecord::TRecord* DeserializeIterable(PyObject* value, bool skipEmptyUgramBuckets);
        };

        class TJsonPyDeserializer {
        public:
            static NZoom::NRecord::TRecord Deserialize(const NJson::TJsonValue& value, bool skipEmptyUgramBuckets);
        };
    }
}
