#include "pydict.h"

using namespace NZoom::NPython;

namespace {

    EType GetPythonType(PyObject* object) {
        if (object == Py_None) {
            return EType::None;
        }
        if (PyString_Check(object) || PyUnicode_Check(object)) {
            return EType::String;
        }
        if (PyInt_Check(object)) {
            return EType::Int;
        }
        if (PyFloat_Check(object)) {
            return EType::Float;
        }
        if (PyList_Check(object)) {
            return EType::Vec;
        }
        if (PyTuple_Check(object)) {
            return EType::Vec;
        }
        return EType::Unknown;
    }

}

TPythonValueHierarchy::TPyValue::TPyValue(PyObject* object)
    : TAbstractValue(GetPythonType(object))
    , Object(object)
{
}

TStringBuf TPythonValueHierarchy::TPyValue::AsString() const {
    AssertType(EType::String);

    char* buf;
    Py_ssize_t len;
    if (PyString_AsStringAndSize(Object, &buf, &len)) {
        ythrow yexception() << "Value is not string";
    }
    return TStringBuf(buf, len);
}


i64 TPythonValueHierarchy::TPyValue::AsInt() const {
    AssertType(EType::Int);
    return PyInt_AsSsize_t(Object);
}

double TPythonValueHierarchy::TPyValue::AsFloat() const {
    AssertType(EType::Float);
    return PyFloat_AsDouble(Object);
}

TPythonValueHierarchy::TPyVec TPythonValueHierarchy::TPyValue::AsVec() const {
    AssertType(EType::Vec);
    return TPyVec(Object);
}


TPythonValueHierarchy::TPyVec::TPyVec(PyObject* object)
    : Object(object)
    , IsList(PyList_Check(object))
{
}

size_t TPythonValueHierarchy::TPyVec::GetSize() const {
    if (IsList) {
        return PyList_Size(Object);
    } else {
        return PyTuple_Size(Object);
    }
}

TPythonValueHierarchy::TPyValue TPythonValueHierarchy::TPyVec::GetItem(const size_t idx) const {
    if (IsList) {
        return TPyValue(PyList_GetItem(Object, idx));
    } else {
        return TPyValue(PyTuple_GetItem(Object, idx));
    }
}


NZoom::NValue::TValue TPythonValueHierarchy::DeserializeValue(PyObject* rootObject, bool skipEmptyUgramBuckets) {
    TPyValue value(rootObject);
    return TValueDeserializer<TPyValue, TPyVec>::GetValue(value, skipEmptyUgramBuckets);
}
