#pragma once

#include <infra/yasm/zoom/components/serialization/deserializers/abstract/abstract_value.h>

#include <Python.h>

namespace NZoom::NPython {
    class TPythonValueHierarchy {
    private:

        class TPyVec;

        class TPyValue: public TAbstractValue {
        private:
            PyObject* Object;

        public:
            TPyValue(PyObject* object);

            TStringBuf AsString() const;
            i64 AsInt() const;
            double AsFloat() const;
            TPyVec AsVec() const;
        };

        class TPyVec {
        private:
            PyObject* Object;
            bool IsList = true;

        public:
            TPyVec(PyObject* object);

            size_t GetSize() const;
            TPyValue GetItem(const size_t idx) const;
        };

    public:
        static NZoom::NValue::TValue DeserializeValue(PyObject* rootObject, bool skipEmptyUgramBuckets);
    };
}
