#pragma once

#include <infra/yasm/zoom/components/record/record.h>
#include <infra/yasm/zoom/components/containers/abstract.h>
#include <infra/yasm/common/points/accumulators/accumulators.h>
#include <infra/yasm/zoom/components/subscription/value_series_merger.h>

#include <library/cpp/pybind/ptr.h>

#include <Python.h>

namespace NZoom {
    namespace NPython {

        PyObject* ValueToPy(const NZoom::NValue::TValueRef& value, bool skipEmptyUgramBuckets);

        class TSignalValueToDictStorage: public NZoom::NRecord::ISignalValueCallback {
        private:
            NPyBind::TPyObjectPtr ObjectHolder;
            bool SkipEmptyUgramBuckets;
        public:
            void Init(bool skipEmptyUgramBuckets);
            PyObject* GetValue();
            PyObject* GetValueRef();
            void OnSignalValue(const NZoom::NSignal::TSignalName& name, const NZoom::NValue::TValueRef& value) override final;
        };

        class TTagRecordToDictStorage: public NZoom::NRecord::ITagRecordCallback {
        private:
            NPyBind::TPyObjectPtr ObjectHolder;

        public:
            void Init();
            PyObject* GetValue();
            void OnTagRecord(NTags::TInstanceKey key, const NZoom::NRecord::TRecord& record) override final;
        };

        class TPyListIterator: public NZoom::NContainers::INameIterator {
        private:
            PyObject* List = nullptr;
            size_t Size = 0;
            size_t Position = 0;

        public:
            TPyListIterator();
            void Init(PyObject* list);

            TStringBuf GetCurrent() const override final;
            bool IsValid() const override final;
            void Next() override final;
        };

        class TContinuousValueToAccumulatorCallback: public NZoom::NRecord::IContinuousValueCallback {
        private:
            NZoom::NAccumulators::TAccumulator& Accumulator;

        public:
            TContinuousValueToAccumulatorCallback(NZoom::NAccumulators::TAccumulator& accumulator);
            void Start() override final;
            void OnValue(const NZoom::NValue::TValueRef& value) override final;
            void Finish() override final;
        };

        class TSubscriptionMergedDataPySerializer {
        public:
            TSubscriptionMergedDataPySerializer(bool allowLegacyTypes);
            void TraverseMergerData(const NSubscription::TSubscriptionValueSeriesMerger& merger);

            PyObject* GetValues();
            PyObject* GetBorders();
            PyObject* GetConvertedSignals();
        private:
            NPyBind::TPyObjectPtr ValueDictHolder;
            NPyBind::TPyObjectPtr BorderDictHolder;
            NPyBind::TPyObjectPtr ConvertedSignalsHolder;
            bool AllowLegacyTypes;
        };
    }
}
