from libcpp cimport bool as bool_t

from cpython cimport PyObject

from infra.yasm.zoom.components.containers.group cimport INameIterator

from infra.yasm.zoom.components.record.record cimport (ISignalValueCallback, ITagRecordCallback,
                                                       IContinuousSignalCallback, IContinuousValueCallback)
from infra.yasm.zoom.components.subscription.subscription cimport TSubscriptionValueSeriesMerger

from infra.yasm.zoom.components.value_types cimport TValueRef


cdef extern from "infra/yasm/zoom/components/serialization/python/zoom_to_py.h" namespace "NZoom::NPython":

    cdef PyObject* ValueToPy(const TValueRef& v, bool_t skipEmptyUgramBuckets) except +

    cdef cppclass TSignalValueToDictStorage(ISignalValueCallback):
        void Init(bool_t skipEmptyUgramBuckets) except +
        PyObject* GetValue() except +

    cdef cppclass TTagRecordToDictStorage(ITagRecordCallback):
        void Init() except +
        PyObject* GetValue() except +

    cdef cppclass TPyListIterator(INameIterator) nogil:
        TPyListIterator() except +
        void Init(PyObject* list) except +

    cdef cppclass TContinuousValueToAccumulatorCallback(IContinuousValueCallback):
        pass

    cdef cppclass TSubscriptionMergedDataPySerializer:
        TSubscriptionMergedDataPySerializer(bool_t allowLegacyTypes) except +
        void TraverseMergerData(const TSubscriptionValueSeriesMerger& merger) except +

        PyObject* GetValues()
        PyObject* GetBorders()
        PyObject* GetConvertedSignals()
