#pragma once

#include <infra/yasm/zoom/components/record/record.h>
#include <infra/yasm/zoom/components/serialization/common/json_utils.h>

namespace NZoom {
    namespace NPython {

        template <typename TUgramCompressorSingleton>
        class TJsonSerializer: public NZoom::NRecord::ISignalValueCallback {
        private:
            NJsonWriter::TBuf& Packer;
            size_t TargetCount = 0;
            size_t ActualCount = 0;

        public:
            TJsonSerializer(NJsonWriter::TBuf& packer)
                : Packer(packer) {
            }

            void SetObjectsCount(const size_t count) override final  {
                if (TargetCount != 0) {
                    ythrow yexception() << "SetObjectsCount() invoked twice";
                } else if (count == 0) {
                    Packer.BeginObject();
                    Packer.EndObject();
                }
                TargetCount = count;
            }

            void OnSignalValue(const NZoom::NSignal::TSignalName& name, const NZoom::NValue::TValueRef& value) override final  {
                if (ActualCount == 0) {
                    Packer.BeginObject();
                }

                Packer.WriteKey(name.GetName());
                TJsonValueRefSerializer<TUgramCompressorSingleton> valueSerializer(Packer);
                value.Update(valueSerializer);

                ++ActualCount;
                if (ActualCount == TargetCount) {
                    Packer.EndObject();
                } else if (TargetCount < ActualCount) {
                    ythrow yexception() << "OnSignalValue() invoked more than requested";
                }
            }
        };

    }

}
