#pragma once

#include <infra/yasm/zoom/components/record/record.h>

#include <contrib/libs/msgpack/include/msgpack.hpp>

namespace NZoom {
    namespace NPython {
        class TMsgPackRefSerializer: public NZoom::NRecord::ISignalValueCallback {
        private:
            msgpack::packer<msgpack::sbuffer>& Packer;
            size_t TargetCount = 0;
            size_t ActualCount = 0;
            const bool SkipEmptyUgramBuckets;

        public:
            TMsgPackRefSerializer(msgpack::packer<msgpack::sbuffer>& Packer, bool skipEmptyUgramBuckets);

            void SetObjectsCount(const size_t count) override final;
            void OnSignalValue(const NZoom::NSignal::TSignalName& name, const NZoom::NValue::TValueRef& value) override final;

            bool IsFinished() const;
        };

        class TMsgPackSerializer: public NZoom::NRecord::ISignalValueCallback {
        private:
            msgpack::sbuffer Buffer;
            msgpack::packer<msgpack::sbuffer> Packer;
            TMsgPackRefSerializer Impl;

        public:
            explicit TMsgPackSerializer(bool skipEmptyUgramBuckets);

            void SetObjectsCount(const size_t count) override final;
            void OnSignalValue(const NZoom::NSignal::TSignalName& name, const NZoom::NValue::TValueRef& value) override final;

            TStringBuf GetValue() const;
        };

        //HistDB-like format - loads record from array of arrays of size 2
        class TMsgPackDeserializer {
        public:
            static NZoom::NRecord::TRecord* Deserialize(TStringBuf value, bool skipEmptyUgramBuckets);
        };

    }

}
