#include "zoom_to_msgpack.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NZoom::NRecord;
using namespace NZoom::NPython;
using namespace NZoom::NHgram;
using namespace NZoom::NValue;
using namespace NZoom::NSignal;

Y_UNIT_TEST_SUITE(TZoomToMsgPackTest) {

    Y_UNIT_TEST(RecordCopyingViaMsgPackSerialization) {
        TVector<std::pair<TSignalName, TValue>> values;
        values.emplace_back(TString("name0"), TValue());
        values.emplace_back(TString("name1"), TValue(1.0));
        values.emplace_back(TString("name2"), TValue(2, 2));
        values.emplace_back(TString("name3"), TValue({1, 2, 3}));
        values.emplace_back(TString("name4"), TValue(THgram::Small({1, 2, 3}, 10)));
        values.emplace_back(TString("name5"), TValue(THgram::Normal({0.0, 51.0, 1.0, 1.0, 50.0}, 0, -1)));

        values.emplace_back(TString("name6"), TValue(
            THgram::Ugram({
                TUgramBucket(1.0, 2.0, 2.0),
                TUgramBucket(2.0, 2.0, 1.0),
                TUgramBucket(2.0, 3.0, 2.0)
             })));
        values.emplace_back(TString("name7"), TValue(TVector<double>({2, 2})));


        TRecord orig(std::move(values));
        TMsgPackSerializer callback(true);
        orig.Process(callback);
        const TStringBuf serializedValue = callback.GetValue();

        THolder<TRecord> copy(TMsgPackDeserializer::Deserialize(serializedValue, true));
        UNIT_ASSERT_EQUAL(orig, *copy);
    }

    Y_UNIT_TEST(EmptyRecord) {
        TVector<std::pair<TSignalName, TValue>> values;
        TRecord orig(std::move(values));

        TMsgPackSerializer callback(true);
        orig.Process(callback);

        THolder<TRecord> copy(TMsgPackDeserializer::Deserialize(callback.GetValue(), true));
        UNIT_ASSERT_EQUAL(orig, *copy);
    }

}
