#include "host_name.h"

using namespace NZoom::NProtobuf;

THostNameSerializer::THostNameSerializer(NYasm::NInterfaces::NInternal::THostNameTable* table)
    : Table(table)
{
}

void THostNameSerializer::Intern(NZoom::NHost::THostName source, NYasm::NInterfaces::NInternal::THostName* dest) {
    THashMap<NZoom::NHost::THostName, ui32>::insert_ctx ctx;
    const auto it = Hosts.find(source, ctx);
    if (it != Hosts.end()) {
        dest->SetIndex(it->second);
        return;
    }
    dest->SetIndex(Hosts.emplace_direct(ctx, source, Table->MutableName()->size())->second);
    *Table->MutableName()->Add() = source.GetName();
}

THostNameDeserializer::THostNameDeserializer(const NYasm::NInterfaces::NInternal::THostNameTable& table) {
    const auto& names = table.GetName();
    if (!names.empty()) {
        Hosts = NZoom::NHost::THostName::CreateMany({names.data(), static_cast<size_t>(names.size())});
    }
}

NZoom::NHost::THostName THostNameDeserializer::Deserialize(const NYasm::NInterfaces::NInternal::THostName& signalName) const {
    return Hosts.at(signalName.GetIndex());
}
