#pragma once

#include <infra/yasm/common/labels/host/host.h>
#include <infra/yasm/interfaces/internal/host_name.pb.h>

#include <util/generic/vector.h>

namespace NZoom::NProtobuf {
    class THostNameSerializer {
    public:
        THostNameSerializer(NYasm::NInterfaces::NInternal::THostNameTable* table);

        void Intern(NZoom::NHost::THostName source, NYasm::NInterfaces::NInternal::THostName* dest);

    private:
        NYasm::NInterfaces::NInternal::THostNameTable* Table;
        THashMap<NZoom::NHost::THostName, ui32> Hosts;
    };

    class THostNameDeserializer {
    public:
        THostNameDeserializer(const NYasm::NInterfaces::NInternal::THostNameTable& table);

        NZoom::NHost::THostName Deserialize(const NYasm::NInterfaces::NInternal::THostName& hostName) const;

    private:
        TVector<NZoom::NHost::THostName> Hosts;
    };
}
