#include "host_name.h"

#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/xrange.h>

using namespace NZoom::NProtobuf;
using namespace NZoom::NHost;

Y_UNIT_TEST_SUITE(THostNameToProtobufTest) {
    Y_UNIT_TEST(Serialization) {
        NYasm::NInterfaces::NInternal::THostNameTable hostTable;
        THostNameSerializer hostSerializer(&hostTable);

        NYasm::NInterfaces::NInternal::THostName host;
        hostSerializer.Intern(THostName(TStringBuf("sas1-1234")), &host);

        THostNameDeserializer hostDeserializer(hostTable);
        UNIT_ASSERT_VALUES_EQUAL(hostDeserializer.Deserialize(host), THostName(TStringBuf("sas1-1234")));
    }

    Y_UNIT_TEST(Missing) {
        NYasm::NInterfaces::NInternal::THostNameTable hostTable;
        THostNameSerializer hostSerializer(&hostTable);

        NYasm::NInterfaces::NInternal::THostName host;
        THostNameDeserializer hostDeserializer(hostTable);
        UNIT_ASSERT_EXCEPTION(hostDeserializer.Deserialize(host), std::out_of_range);
    }
}
