#include "instance_key.h"

using namespace NZoom::NProtobuf;

TInstanceKeySerializer::TInstanceKeySerializer(NYasm::NInterfaces::NInternal::TInstanceKeyTable* table)
    : Table(table)
{
}

void TInstanceKeySerializer::Intern(NTags::TInstanceKey source, NYasm::NInterfaces::NInternal::TInstanceKey* dest) {
    THashMap<NTags::TInstanceKey, ui32>::insert_ctx ctx;
    const auto it = Keys.find(source, ctx);
    if (it != Keys.end()) {
        dest->SetIndex(it->second);
        return;
    }
    dest->SetIndex(Keys.emplace_direct(ctx, source, Table->MutableName()->size())->second);
    *Table->MutableName()->Add() = source.ToNamed();
}

TInstanceKeyDeserializer::TInstanceKeyDeserializer(const NYasm::NInterfaces::NInternal::TInstanceKeyTable& table) {
    const auto& names = table.GetName();
    if (!names.empty()) {
        Keys = NTags::TInstanceKey::CreateMany({names.data(), static_cast<size_t>(names.size())});
    }
}

NTags::TInstanceKey TInstanceKeyDeserializer::Deserialize(const NYasm::NInterfaces::NInternal::TInstanceKey& instanceKey) const {
    return Keys.at(instanceKey.GetIndex());
}
