#pragma once

#include <infra/yasm/common/labels/tags/instance_key.h>
#include <infra/yasm/interfaces/internal/instance_key.pb.h>

#include <util/generic/vector.h>

namespace NZoom::NProtobuf {
    class TInstanceKeySerializer {
    public:
        TInstanceKeySerializer(NYasm::NInterfaces::NInternal::TInstanceKeyTable* table);

        void Intern(NTags::TInstanceKey source, NYasm::NInterfaces::NInternal::TInstanceKey* dest);

    private:
        NYasm::NInterfaces::NInternal::TInstanceKeyTable* Table;
        THashMap<NTags::TInstanceKey, ui32> Keys;
    };

    class TInstanceKeyDeserializer {
    public:
        TInstanceKeyDeserializer(const NYasm::NInterfaces::NInternal::TInstanceKeyTable& table);

        NTags::TInstanceKey Deserialize(const NYasm::NInterfaces::NInternal::TInstanceKey& instanceKey) const;

    private:
        TVector<NTags::TInstanceKey> Keys;
    };
}
