#include "instance_key.h"

#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/xrange.h>

using namespace NZoom::NProtobuf;
using namespace NTags;

Y_UNIT_TEST_SUITE(TInstanceKeyToProtobufTest) {
    Y_UNIT_TEST(Serialization) {
        NYasm::NInterfaces::NInternal::TInstanceKeyTable keyTable;
        TInstanceKeySerializer keySerializer(&keyTable);

        NYasm::NInterfaces::NInternal::TInstanceKey key;
        keySerializer.Intern(TInstanceKey::FromNamed("common||ctype,geo,prj,tier"), &key);

        TInstanceKeyDeserializer keyDeserializer(keyTable);
        UNIT_ASSERT_VALUES_EQUAL(keyDeserializer.Deserialize(key), TInstanceKey::FromNamed("common||ctype,geo,prj,tier"));
    }

    Y_UNIT_TEST(Missing) {
        NYasm::NInterfaces::NInternal::TInstanceKeyTable keyTable;
        TInstanceKeySerializer keySerializer(&keyTable);

        NYasm::NInterfaces::NInternal::TInstanceKey key;
        TInstanceKeyDeserializer keyDeserializer(keyTable);
        UNIT_ASSERT_EXCEPTION(keyDeserializer.Deserialize(key), std::out_of_range);
    }
}
