#include "record.h"

namespace NZoom::NProtobuf {
    using namespace NRecord;
    using namespace NSignal;
    using namespace NValue;

    TRecord DeserializeProtobufRecord(const NYasm::NInterfaces::NInternal::TRecord& record,
                                      const TSignalNameDeserializer& deserializer,
                                      bool skipEmptyUgramBuckets) {
        TVector<std::pair<TSignalName, TValue>> values(Reserve(record.GetValues().size()));
        for (const auto& pair : record.GetValues()) {
            values.emplace_back(
                deserializer.Deserialize(pair.GetSignalName()),
                DeserializeProtobufValue(pair.GetValue(), skipEmptyUgramBuckets)
            );
        }
        return TRecord(std::move(values));
    }

    TProtobufWrappingValue DeserializeProtobufValueByWrapping(const NYasm::NInterfaces::NInternal::TValue& value) {
        return TProtobufWrappingValue(value);
    }
}
