#pragma once

#include <infra/yasm/zoom/components/record/record.h>
#include <infra/yasm/interfaces/internal/record.pb.h>

#include <infra/yasm/zoom/components/serialization/zoom_to_protobuf/signal_name.h>
#include <infra/yasm/zoom/components/serialization/zoom_to_protobuf/value.h>

namespace NZoom::NProtobuf {
    template <class TUgramCompressorSingleton>
    class TProtobufRecordSerializer: public NZoom::NRecord::ISignalValueCallback {
    public:
        TProtobufRecordSerializer(NYasm::NInterfaces::NInternal::TRecord& record, TSignalNameSerializer& signalNameSerializer)
            : Record(record)
            , SignalNameSerializer(signalNameSerializer)
        {
        }

        void SetObjectsCount(const size_t count) override final  {
            Record.MutableValues()->Reserve(count);
        }

        void OnSignalValue(const NZoom::NSignal::TSignalName& name, const NZoom::NValue::TValueRef& value) override final {
            auto* pair = Record.MutableValues()->Add();
            SignalNameSerializer.Intern(name, pair->MutableSignalName());
            TProtobufValueSerializer<TUgramCompressorSingleton> serializer(*pair->MutableValue());
            value.Update(serializer);
        }

    private:
        NYasm::NInterfaces::NInternal::TRecord& Record;
        TSignalNameSerializer& SignalNameSerializer;
    };

    NZoom::NRecord::TRecord DeserializeProtobufRecord(const NYasm::NInterfaces::NInternal::TRecord& record,
                                                      const TSignalNameDeserializer& deserializer,
                                                      bool skipEmptyUgramBuckets);

    /**
     * Class for deserialization of proto records that attempts to avoid creation of intermediate value objects.
     * IMPORTANT: Deserialized structures should not live longer than the deserialized proto message.
     */
    template <typename TVisitor>
    static void DeserializeRecordsByWrappingValuesAndVisit(const NYasm::NInterfaces::NInternal::TRecord& record,
                                                           const TSignalNameDeserializer& deserializer,
                                                           TVisitor visitor) {
        for (const auto& pair : record.GetValues()) {
            visitor(
                deserializer.Deserialize(pair.GetSignalName()),
                DeserializeProtobufValueByWrapping(pair.GetValue())
            );
        }
    }
}
