#include "request_key.h"

namespace NZoom {
    using namespace NProtobuf;
    using namespace NSubscription;
    namespace NYasmProto = NYasm::NInterfaces::NInternal;

    TInternedRequestKeySerializer::TInternedRequestKeySerializer(NYasmProto::TRequestKeyTable* table)
        : Table(table) {
    }

    void TInternedRequestKeySerializer::Intern(const TInternedRequestKey& source, NYasmProto::TInternedRequestKey* dest) {
        decltype(Keys)::insert_ctx ctx;
        const auto it = Keys.find(source, ctx);
        if (it != Keys.end()) {
            dest->SetIndex(it->second);
            return;
        }
        dest->SetIndex(Keys.emplace_direct(ctx, source, Table->MutableName()->size())->second);
        *Table->MutableName()->Add() = source.GetName();
    }

    TInternedRequestKeyDeserializer::TInternedRequestKeyDeserializer(const NYasmProto::TRequestKeyTable& table) {
        Keys.reserve(table.NameSize());
        KeysAsRequested.reserve(table.NameSize());
        for (const auto& name: table.GetName()) {
            Keys.emplace_back(name);
            KeysAsRequested.push_back(name);
        }
    }

    const TInternedRequestKey& TInternedRequestKeyDeserializer::Deserialize(
        const NYasmProto::TInternedRequestKey& instanceKey) const {
        return Keys.at(instanceKey.GetIndex());
    }

    TInternedRequestKeyDeserializer::TFullInfo TInternedRequestKeyDeserializer::DeserializeWithFullInfo(
        const NYasm::NInterfaces::NInternal::TInternedRequestKey& instanceKey) const {
        return TFullInfo(Keys.at(instanceKey.GetIndex()), KeysAsRequested.at(instanceKey.GetIndex()));
    }
}
