#pragma once

#include <infra/yasm/zoom/components/subscription/request_key.h>
#include <infra/yasm/interfaces/internal/request_key.pb.h>

#include <util/generic/vector.h>

namespace NZoom::NProtobuf {
    class TInternedRequestKeySerializer {
    public:
        explicit TInternedRequestKeySerializer(NYasm::NInterfaces::NInternal::TRequestKeyTable* table);

        void Intern(const NSubscription::TInternedRequestKey& source, NYasm::NInterfaces::NInternal::TInternedRequestKey* dest);

    private:
        NYasm::NInterfaces::NInternal::TRequestKeyTable* Table;
        THashMap<NSubscription::TInternedRequestKey, ui32> Keys;
    };

    class TInternedRequestKeyDeserializer {
    public:
        using TFullInfo = std::pair<const NSubscription::TInternedRequestKey&, const TString&>;

        explicit TInternedRequestKeyDeserializer(const NYasm::NInterfaces::NInternal::TRequestKeyTable& table);

        const NSubscription::TInternedRequestKey& Deserialize(
            const NYasm::NInterfaces::NInternal::TInternedRequestKey& instanceKey) const;

        TFullInfo DeserializeWithFullInfo(const NYasm::NInterfaces::NInternal::TInternedRequestKey& instanceKey) const;
    private:
        TVector<NSubscription::TInternedRequestKey> Keys;
        TVector<TString> KeysAsRequested;
    };
}
