#include "request_key.h"

#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/xrange.h>

using namespace NZoom::NProtobuf;
using namespace NZoom::NSubscription;

Y_UNIT_TEST_SUITE(TInternedRequestKeyToProtobufTest) {
    Y_UNIT_TEST(Serialization) {
        NYasm::NInterfaces::NInternal::TRequestKeyTable keyTable;
        TInternedRequestKeySerializer keySerializer(&keyTable);

        NYasm::NInterfaces::NInternal::TInternedRequestKey key;
        keySerializer.Intern(TInternedRequestKey(TStringBuf("itype=app;ctype=prod;prj=project;geo=sas")), &key);

        TInternedRequestKeyDeserializer keyDeserializer(keyTable);
        UNIT_ASSERT_VALUES_EQUAL(keyDeserializer.Deserialize(key),
            TInternedRequestKey(TStringBuf("ctype=prod;geo=sas;prj=project;itype=app")));
    }

    Y_UNIT_TEST(Missing) {
        NYasm::NInterfaces::NInternal::TRequestKeyTable keyTable;
        TInternedRequestKeySerializer keySerializer(&keyTable);

        NYasm::NInterfaces::NInternal::TInternedRequestKey key;
        TInternedRequestKeyDeserializer keyDeserializer(keyTable);
        UNIT_ASSERT_EXCEPTION(keyDeserializer.Deserialize(key), std::out_of_range);
    }

    Y_UNIT_TEST(DeserializeFull) {
        NYasm::NInterfaces::NInternal::TRequestKeyTable keyTable;
        NYasm::NInterfaces::NInternal::TInternedRequestKey key;
        TString requestedAs("ctype=prod;geo=sas;prj=project;itype=app");

        keyTable.AddName(requestedAs);
        key.SetIndex(0);

        TInternedRequestKeyDeserializer keyDeserializer(keyTable);
        const auto& [actualRequestKey, actualKeyAsRequested] = keyDeserializer.DeserializeWithFullInfo(key);
        UNIT_ASSERT_VALUES_EQUAL(TInternedRequestKey(TStringBuf("itype=app;ctype=prod;prj=project;geo=sas")), actualRequestKey);
        UNIT_ASSERT_VALUES_EQUAL(requestedAs, actualKeyAsRequested);
    }
}
